// Service Worker — cache-first con fallback de red (subruta /pwa-demo-menu/)
const CACHE_NAME = 'pwa-menu-v1';
const BASE = '/pwa-demo-menu/';
const ASSETS = [
  BASE,
  BASE + 'index.html',
  BASE + 'offline.html',
  BASE + 'manifest.json',
  BASE + 'assets/css/styles.css',
  BASE + 'assets/js/app.js',
  BASE + 'assets/menu.json',
  BASE + 'assets/img/icon-192.png',
  BASE + 'assets/img/icon-512.png'
];

self.addEventListener('install', (event) => {
  event.waitUntil(caches.open(CACHE_NAME).then(cache => cache.addAll(ASSETS)));
  self.skipWaiting();
});

self.addEventListener('activate', (event) => {
  event.waitUntil((async () => {
    const keys = await caches.keys();
    await Promise.all(keys.map(k => k !== CACHE_NAME && caches.delete(k)));
  })());
  self.clients.claim();
});

self.addEventListener('fetch', (event) => {
  const { request } = event;
  const url = new URL(request.url);
  if (request.method !== 'GET') return;
  // Limitar a la subruta de la PWA
  if (!url.pathname.startsWith(BASE)) return;
  event.respondWith((async () => {
    try {
      const cache = await caches.open(CACHE_NAME);
      const cached = await cache.match(request);
      const networkFetch = fetch(request).then(res => {
        cache.put(request, res.clone());
        return res;
      });
      return cached || networkFetch;
    } catch (e) {
      if (request.headers.get('accept')?.includes('text/html')) {
        return caches.match(BASE + 'offline.html');
      }
      throw e;
    }
  })());
});
