// Carga del menú y búsqueda (subruta /pwa-demo-menu/)
const menuEl = document.getElementById('menu');
const searchEl = document.getElementById('search');

async function cargarMenu() {
  try {
    const res = await fetch('/pwa-demo-menu/assets/menu.json', {cache: 'no-store'});
    const data = await res.json();
    render(data.items);
  } catch (e) {
    console.error('Error cargando menú', e);
    menuEl.innerHTML = `<div class="card"><h3>No se pudo cargar el menú</h3><p>Verifica tu conexión.</p></div>`;
  }
}

function render(items) {
  const q = (searchEl.value || '').toLowerCase().trim();
  const filtered = items.filter(item => 
    item.titulo.toLowerCase().includes(q) ||
    item.descripcion.toLowerCase().includes(q) ||
    item.categoria.toLowerCase().includes(q)
  );
  if (filtered.length === 0) {
    menuEl.innerHTML = `<div class="card"><h3>Sin resultados</h3><p>Intenta con otra búsqueda.</p></div>`;
    return;
  }
  menuEl.innerHTML = filtered.map(item => `
    <article class="card" tabindex="0" aria-label="${item.titulo}">
      <h3>${item.titulo}</h3>
      <p>${item.descripcion}</p>
      <span class="tag">${item.categoria}</span>
      <div class="price">$${item.precio}</div>
    </article>
  `).join('');
}

searchEl?.addEventListener('input', () => cargarMenu());

// Botón de instalación (PWA)
let deferredPrompt;
const installBtn = document.getElementById('installBtn');
window.addEventListener('beforeinstallprompt', (e) => {
  e.preventDefault();
  deferredPrompt = e;
  installBtn.hidden = false;
});
installBtn?.addEventListener('click', async () => {
  if (!deferredPrompt) return;
  deferredPrompt.prompt();
  await deferredPrompt.userChoice;
  deferredPrompt = null;
  installBtn.hidden = true;
});

cargarMenu();


// Registro del Service Worker (sin inline, compatible con CSP estricto)
if ('serviceWorker' in navigator) {
  window.addEventListener('load', () => {
    navigator.serviceWorker.register('/pwa-demo-menu/sw.js', { scope: '/pwa-demo-menu/' }).catch(console.error);
  });
}
